VERSION 5.00
Object = "{AC957AC8-A491-11CE-A69B-0000E8A490E7}#1.0#0"; "WDTVOCX.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4275
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9015
   LinkTopic       =   "Form2"
   ScaleHeight     =   4275
   ScaleWidth      =   9015
   StartUpPosition =   2  'CenterScreen
   Begin SAPTableView.SAPTableView SAPTableView1 
      Height          =   3435
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   4815
      _Version        =   2
      _ExtentX        =   8493
      _ExtentY        =   6059
      _StockProps     =   109
      BackColor       =   16777215
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty CtrlVColsVCollFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty CtrlVRowsVCollFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' This sample program is an enhanced version of the CompanyCode sample program.
' It displays a list of company codes with additional information:
' - country code for each company code
' - descriptive text for each country code
' - city for each country code
' In addition to the features shown in the CompanyCode sample program, this program shows how to use
' - the GetHelpDataAsTable method to produce a table containing all values for an entity
'   (e.g. country code) and the descriptive texts for each value
' - the ExtendTableByColumns method to create a copy of a table with space for more information,
'   in this case the extra columns mentioned above

Private SAP As New araSAP

Private Sub Form_Load()
Dim ahView As araHelpView
Dim atColumns As New aratableColumns
Dim fX As araField
Dim oCompanyCode As Object
Dim oRow As Object
Dim oRowCountry As Object
Dim ostructDetail As Object
Dim otabCompanyCodeList As Object
Dim otabCountries As Object
Dim otabNew As Object
Dim sStructureNameCCList As String
Dim sStructureNameCCDetail As String
  Caption = App.Title

' Logon using the provided Connection object
  If SAP.Connection.Logon(0, False) Then
' If you want transparent logon, try the next line instead: (fill in appropriate values)
' If SAP.TransparentLogon("SYSTEMNAME", "001", "USERID", "PASSWORD", "LANGUAGE") Then
    
' Use the ClassObjects collection if you just want to call a class method:
    SAP.ClassObjects("CompanyCode").GetList CompanyCodeList:=otabCompanyCodeList

' Get a table with all country codes and their descriptive texts, store it in otabCountries
' (This function also returns the structure of the help view, stored in ahView)
    Set otabCountries = GetHelpDataAsTable(ahView, "CompanyCode", "GetDetail", "CompanyCodeDetail", "Country")
    
' Make the country code column the key column to look up country codes
' (Use the HelpView sample program to look up the table and field names in a help view)
    otabCountries.Columns.KeyColumn = otabCountries.Columns("LAND1").Index

' Get the internal name for the structure used for the CompanyCodeList parameter
    sStructureNameCCList = GetStructureName(SAP.ClassObjects("CompanyCode"), "GetList", "CompanyCodeList")
' Get the internal name for the structure used for the CompanyCodeDetail parameter
    sStructureNameCCDetail = GetStructureName(SAP.ClassObjects("CompanyCode"), "GetDetail", "CompanyCodeDetail")

' Add column objects to the column collection in preparation for the table extension
    Set fX = SAP.Structures(sStructureNameCCDetail).Fields("COUNTRY")
    atColumns.Add2 fX.Name, ConvertABAPTypeToRFCType(fX.DataType), fX.Length
' (Use the HelpView sample program to look up the table and field names in a help view)
    Set fX = SAP.Structures("T005T").Fields("LANDX")
    atColumns.Add2 fX.Name, ConvertABAPTypeToRFCType(fX.DataType), fX.Length
    Set fX = SAP.Structures(sStructureNameCCDetail).Fields("CITY")
    atColumns.Add2 fX.Name, ConvertABAPTypeToRFCType(fX.DataType), fX.Length

' Extend the table by the new columns
    Set otabNew = ExtendTableByColumns(otabCompanyCodeList, atColumns)

' Get the detail information for each company code
    For Each oRow In otabNew.Rows
      Set oCompanyCode = SAP.BAPIControl.GetSAPObject("CompanyCode", oRow("COMP_CODE"))
      oCompanyCode.GetDetail CompanyCodeDetail:=ostructDetail

' Copy the city to the new table
      oRow("CITY") = ostructDetail("CITY")
      
' Copy the country code to the new table
      oRow("COUNTRY") = ostructDetail("COUNTRY")
      
' If a country is defined for this company code,
' get the descriptive text for it and copy it to the new table
      If oRow("COUNTRY") <> "" Then
        Set oRowCountry = otabCountries.Rows(oRow("COUNTRY"))
        oRow("LANDX") = oRowCountry("LANDX")
      End If
      
    Next oRow

' Use the SAP TableView to display the contents of the table
    otabNew.Views.Add SAPTableView1.Object
    otabNew.Refresh

' Get the appropriate texts for the column headers
    SAPTableView1.Columns(1).Header = _
      SAP.Structures(sStructureNameCCList).Fields("COMP_CODE").LabelShort
    SAPTableView1.Columns(2).Header = _
      SAP.Structures(sStructureNameCCList).Fields("COMP_NAME").LabelShort
    SAPTableView1.Columns(3).Header = _
      SAP.Structures(sStructureNameCCDetail).Fields("COUNTRY").LabelShort
' (Use the HelpView sample program to look up the table and field names in a help view)
    SAPTableView1.Columns(4).Header = _
      SAP.Structures("T005T").Fields("LANDX").LabelShort
    SAPTableView1.Columns(5).Header = _
      SAP.Structures(sStructureNameCCDetail).Fields("CITY").LabelShort
  
    
' Adjust the width of all columns
    SAPTableView1.ColumnAutoWidth 1, SAPTableView1.ColumnCount
  
  Else
    MsgBox "Logon failed."
  End If
End Sub

Private Sub Form_Resize()
  SAPTableView1.Move 0, 0, ScaleWidth, ScaleHeight
End Sub
